***********************************************************************
***********DEBT AND CONSUMPTION - MODELS with interactions ************
*************************DATE: MAY 2019 *******************************
************************ AUTHOR: FIONA PRICE **************************
***********************************************************************
clear
set more off
use "C:\UnbalancedHH_analytical NEW.dta", replace
sort hhid0 wave

replace hdebtt = . if hdebtt!=. & own==1 & purchase==0 // missing if don't have information on when they purchased property
replace hdebtt = . if hdebtt==0 & hhmove==0 & own==1 & L.hdebt!=0 & F.hdebt!=0 // missing if don't have information on when they purchased property

//set up list of control variables for model
local controlvars inct L.hp1t i.agewmax i.educ kids hhadult married unemp nilf
* Interaction variables: Table 3(lcons htm_adj behindnew1 lvrorig80); Table 4(casual losejob); Table 7(crisis shockdum becunemp neghprice) 

*************
***TABLE 3***
*************
mat Table3 = J(12,4,.)
mat rown Table3 = Debtcoef Debtpv Intcoeff Intpv Inccoeff Incpb Incintcoeff Incintpb Hpcoeff Hppv Hpintcoeff Hpintpv
mat coln Table3 = LVR HTM Behind Stress

local i=1
local contin 1. //if continuous needs c. and if dummy needs 1
foreach interactedvar in highlvr htm_adj behindnew1 lcons {
xtreg consumpt `controlvars' `contin'`interactedvar'#cL.hp1t `contin'`interactedvar'#c.inct `contin'`interactedvar'#cL.hdebtt L.hdebtt `interactedvar' if L.hdebtt>0 & touse==1 & touse2==1 & touse3==1 & wave>=6 & wave<=10,  fe cluster(hhid0) robust
mat Table3[1,`i']=_b[L.hdebtt]
mat Table3[2,`i']=(2 * ttail(e(df_r), abs(_b[L.hdebtt]/_se[L.hdebtt])))
mat Table3[3,`i']=_b[`contin'`interactedvar'#cL.hdebtt]
mat Table3[4,`i']=(2 * ttail(e(df_r), abs(_b[`contin'`interactedvar'#cL.hdebtt]/_se[`contin'`interactedvar'#cL.hdebtt])))
mat Table3[5,`i']=_b[inct]
mat Table3[6,`i']=(2 * ttail(e(df_r), abs(_b[inct]/_se[inct])))
mat Table3[7,`i']=_b[`contin'`interactedvar'#c.inct]
mat Table3[8,`i']=(2 * ttail(e(df_r), abs(_b[`contin'`interactedvar'#c.inct]/_se[`contin'`interactedvar'#c.inct])))
mat Table3[9,`i']=_b[L.hp1t]
mat Table3[10,`i']=(2 * ttail(e(df_r), abs(_b[L.hp1t]/_se[L.hp1t])))
mat Table3[11,`i']=_b[`contin'`interactedvar'#c.L.hp1t]
mat Table3[12,`i']=(2 * ttail(e(df_r), abs(_b[`contin'`interactedvar'#c.L.hp1t]/_se[`contin'`interactedvar'#c.L.hp1t])))
local i = `i'+1
}
matlist Table3


*************
***TABLE 4***
*************
mat Table4 = J(12,2,.)
mat rown Table4 = Debtcoef Debtpv Intcoeff Intpv Inccoeff Incpb Incintcoeff Incintpb Hpcoeff Hppv Hpintcoeff Hpintpv
mat coln Table4 = casual losejob

local i=1
local contin 1. //if continuous needs c. and if dummy needs 1
foreach interactedvar in casual losejob {
xtreg consumpt `controlvars' `contin'`interactedvar'#cL.hp1t `contin'`interactedvar'#c.inct `contin'`interactedvar'#cL.hdebtt L.hdebtt `interactedvar' if L.hdebtt>0 & touse==1 & touse2==1 & touse3==1 & wave>=6 & wave<=10,  fe cluster(hhid0) robust
mat Table4[1,`i']=_b[L.hdebtt]
mat Table4[2,`i']=(2 * ttail(e(df_r), abs(_b[L.hdebtt]/_se[L.hdebtt])))
mat Table4[3,`i']=_b[`contin'`interactedvar'#cL.hdebtt]
mat Table4[4,`i']=(2 * ttail(e(df_r), abs(_b[`contin'`interactedvar'#cL.hdebtt]/_se[`contin'`interactedvar'#cL.hdebtt])))
mat Table4[5,`i']=_b[inct]
mat Table4[6,`i']=(2 * ttail(e(df_r), abs(_b[inct]/_se[inct])))
mat Table4[7,`i']=_b[`contin'`interactedvar'#c.inct]
mat Table4[8,`i']=(2 * ttail(e(df_r), abs(_b[`contin'`interactedvar'#c.inct]/_se[`contin'`interactedvar'#c.inct])))
mat Table4[9,`i']=_b[L.hp1t]
mat Table4[10,`i']=(2 * ttail(e(df_r), abs(_b[L.hp1t]/_se[L.hp1t])))
mat Table4[11,`i']=_b[`contin'`interactedvar'#c.L.hp1t]
mat Table4[12,`i']=(2 * ttail(e(df_r), abs(_b[`contin'`interactedvar'#c.L.hp1t]/_se[`contin'`interactedvar'#c.L.hp1t])))
local i = `i'+1
}
matlist Table4


*************
***TABLE 7***
*************
mat Table7 = J(13,4,.)
mat rown Table7 = Debtcoef Debtpv Intcoeff Intpv Inccoeff Incpb Incintcoeff Incintpb Hpcoeff Hppv Hpintcoeff Hpintpv n
mat coln Table7 = crisis becunemp shockdum neghprice

local i=1
local contin 1. //if continuous needs c. and if dummy needs 1
foreach interactedvar in crisis becunemp shockdum neghprice {
xtreg consumpt `controlvars' `contin'`interactedvar'#cL.hp1t `contin'`interactedvar'#c.inct `contin'`interactedvar'#cL.hdebtt L.hdebtt `interactedvar' if L.hdebtt>0 & touse==1 & touse2==1 & touse3==1 & wave>=6 & wave<=10,  fe cluster(hhid0) robust
mat Table7[1,`i']=_b[L.hdebtt]
mat Table7[2,`i']=(2 * ttail(e(df_r), abs(_b[L.hdebtt]/_se[L.hdebtt])))
mat Table7[3,`i']=_b[`contin'`interactedvar'#cL.hdebtt]
mat Table7[4,`i']=(2 * ttail(e(df_r), abs(_b[`contin'`interactedvar'#cL.hdebtt]/_se[`contin'`interactedvar'#cL.hdebtt])))
mat Table7[5,`i']=_b[inct]
mat Table7[6,`i']=(2 * ttail(e(df_r), abs(_b[inct]/_se[inct])))
mat Table7[7,`i']=_b[`contin'`interactedvar'#c.inct]
mat Table7[8,`i']=(2 * ttail(e(df_r), abs(_b[`contin'`interactedvar'#c.inct]/_se[`contin'`interactedvar'#c.inct])))
mat Table7[9,`i']=_b[L.hp1t]
mat Table7[10,`i']=(2 * ttail(e(df_r), abs(_b[L.hp1t]/_se[L.hp1t])))
mat Table7[11,`i']=_b[`contin'`interactedvar'#c.L.hp1t]
mat Table7[12,`i']=(2 * ttail(e(df_r), abs(_b[`contin'`interactedvar'#c.L.hp1t]/_se[`contin'`interactedvar'#c.L.hp1t])))
mat Table7[13,`i']=e(N)
local i = `i'+1
}
matlist Table7
